<?php
// db.php for database connection
include('db.php');

// Initialize the response array
$response = array();

// Check if the 'id' parameter is provided in the URL
if (isset($_GET['id'])) {
    // Sanitize and validate the 'id'
    $customer_id = intval($_GET['id']); // Convert to an integer
    if ($customer_id <= 0) { // Validate: Ensure it's a positive number
        $response = array("message" => "Invalid Customer ID");
        echo json_encode($response);
        exit;
    }

    // Build the SQL query to fetch customer data
    $query = "SELECT * FROM customer WHERE id = $customer_id AND delete_status=0";

    // Execute the query
    $result = mysqli_query($conn, $query);

    // Check if the query was successful
    if ($result && mysqli_num_rows($result) > 0) {
        // Fetch the customer data as an associative array
        $response = mysqli_fetch_assoc($result); // Directly assign all data to the response
    } else {
        // No customer found
        $response = array("message" => "Customer not found");
    }
} else {
    // 'id' parameter not provided
    $response = array("message" => "Customer ID is required");
}

// Close the database connection
mysqli_close($conn);

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
